/**
 * Video Pop
 */
jQuery( document ).ready( function( $ ) {
	$( '.kadence-video-popup-link.kadence-video-type-external' ).magnificPopup( {
		type: 'iframe',
		removalDelay: 400,
		mainClass: 'mfp-kt-blocks',
		callbacks: {
			beforeOpen: function() {
				this.st.iframe.markup = '<div class="mfp-with-anim">' + this.st.iframe.markup + '</div>';
				this.st.mainClass = this.st.mainClass + ' kadence-vpop-anim-' + this.st.el.attr( 'data-effect' ) + ' ' + this.st.el.attr( 'data-popup-class' );
			},
		},
	} );
	$( '.kadence-video-popup-link.kadence-video-type-local' ).each( function() {
		var id = $( this ).attr( 'data-popup-id' );
		var auto = $( this ).attr( 'data-popup-auto' );
		$( this ).magnificPopup( {
			mainClass: 'mfp-kt-blocks',
			removalDelay: 400,
			items: {
				src: '#' + id,
				type: 'inline',
			},
			callbacks: {
				beforeOpen: function() {
					this.st.mainClass = this.st.mainClass + ' kadence-vpop-anim-' + this.st.el.attr( 'data-effect' ) + ' ' + this.st.el.attr( 'data-popup-class' );
				},
				open: function() {
					// Play video on open:
					if ( 'true' == auto ) {
						$( this.content ).find( 'video' )[ 0 ].play();
					}
				},
				close: function() {
					// Pause video on close:
					$( this.content ).find( 'video' )[ 0 ].pause();
				},
			},
		} );
	} );
} );
