(window.yoastPremiumWebpackJsonp=window.yoastPremiumWebpackJsonp||[]).push([[5],{128:function(module,exports,__webpack_require__){"use strict";eval('\n\n/* global ajaxurl */\n/* jshint -W097 */\n\nvar redirectFunctions = __webpack_require__(18);\n\n/**\n * Use notification counter so we can count how many times the function wpseoShowNotification is called.\n *\n * @type {number}\n */\nvar wpseoNotificationCounter = 0;\n\n/**\n * Show notification to user when there\'s a redirect created. When the response is empty, up the notification counter\n * with 1, wait 100 ms and call function again.\n * Stop when the notification counter is bigger than 20.\n *\n * @returns {void}\n */\nfunction wpseoShowNotification() {\n\tjQuery.post(ajaxurl, { action: "yoast_get_notifications" }, function (response) {\n\t\tif (response !== "") {\n\t\t\tvar insertAfterElement = jQuery(".wrap").children().eq(0);\n\t\t\tjQuery(response).insertAfter(insertAfterElement);\n\t\t\twpseoNotificationCounter = 0;\n\t\t}\n\n\t\tif (wpseoNotificationCounter < 20 && response === "") {\n\t\t\twpseoNotificationCounter++;\n\t\t\tsetTimeout(wpseoShowNotification, 500);\n\t\t}\n\t});\n}\n\nwindow.wpseoShowNotification = wpseoShowNotification;\n\n/**\n * Gets the current page based on the current URL.\n *\n * @returns {string} The current page.\n */\nfunction wpseoGetCurrentPage() {\n\treturn jQuery(location).attr("pathname").split("/").pop();\n}\n\nwindow.wpseoGetCurrentPage = wpseoGetCurrentPage;\n\n/**\n * Gets the name of the field to get the slug from, based on the current URL.\n *\n * For posts, this is \'post_name\', for terms it is \'slug\'.\n *\n * @param {string} currentPage The current page.\n *\n * @returns {string} The current slug field name.\n */\nfunction wpseoGetSlugField(currentPage) {\n\tcurrentPage = currentPage || wpseoGetCurrentPage();\n\n\tif (currentPage === "edit-tags.php") {\n\t\treturn "slug";\n\t}\n\n\treturn "post_name";\n}\n\n/**\n * Gets the current slug of a post based on the current page and post or term being edited.\n *\n * @returns {string} The slug of the current post or term.\n */\nfunction wpseoGetCurrentSlug() {\n\tvar currentPost = wpseoGetItemId();\n\tvar slugField = wpseoGetSlugField();\n\n\treturn jQuery("#inline_" + currentPost).find("." + slugField).html();\n}\n\nwindow.wpseoGetCurrentSlug = wpseoGetCurrentSlug;\n\n/**\n * Checks whether or not the slug has changed.\n *\n * @returns {boolean} Whether or not the slug has changed.\n */\nfunction wpseoSlugChanged() {\n\tvar editor = wpseoGetActiveEditor();\n\tvar slugField = wpseoGetSlugField();\n\tvar currentSlug = wpseoGetCurrentSlug();\n\tvar newSlug = editor.find("input[name=" + slugField + "]").val();\n\n\treturn currentSlug !== newSlug;\n}\n\nwindow.wpseoSlugChanged = wpseoSlugChanged;\n\n/**\n * Gets the currently active editor used in quick edit.\n *\n * @returns {Object} The editor that is currently active.\n */\nfunction wpseoGetActiveEditor() {\n\treturn jQuery("tr.inline-editor");\n}\n\nwindow.wpseoGetActiveEditor = wpseoGetActiveEditor;\n\n/**\n * Gets the current post or term id.\n * Returns an empty string if no editor is currently active.\n *\n * @returns {string} The ID of the current post or term.\n */\nfunction wpseoGetItemId() {\n\tvar editor = wpseoGetActiveEditor();\n\n\tif (editor.length === 0 || editor === "") {\n\t\treturn "";\n\t}\n\n\treturn editor.attr("id").replace("edit-", "");\n}\n\nwindow.wpseoGetItemId = wpseoGetItemId;\n\n/**\n * Handles the key-based events in the quick edit editor.\n *\n * @param {Event} ev The event currently being executed.\n *\n * @returns {void}\n */\nfunction wpseoHandleKeyEvents(ev) {\n\t// 13 refers to the enter key.\n\tif (ev.which === 13 && wpseoSlugChanged()) {\n\t\twpseoShowNotification();\n\t}\n}\n\nwindow.wpseoHandleKeyEvents = wpseoHandleKeyEvents;\n\n/**\n * Handles the button-based events in the quick edit editor.\n *\n * @param {Event} ev The event currently being executed.\n *\n * @returns {void}\n */\nfunction wpseoHandleButtonEvents(ev) {\n\tif (jQuery(ev.target).attr("id") !== "save-order" && wpseoSlugChanged()) {\n\t\twpseoShowNotification();\n\t}\n}\n\nwindow.wpseoHandleButtonEvents = wpseoHandleButtonEvents;\n\nwindow.wpseoUndoRedirect = redirectFunctions.wpseoUndoRedirect;\nwindow.wpseoCreateRedirect = redirectFunctions.wpseoCreateRedirect;\nwindow.wpseoRemoveNotification = redirectFunctions.wpseoRemoveNotification;\n\njQuery(function () {\n\tvar wpseoCurrentPage = wpseoGetCurrentPage();\n\n\tif (["edit.php", "edit-tags.php"].includes(wpseoCurrentPage)) {\n\t\tjQuery("#inline-edit input").on("keydown", function (ev) {\n\t\t\twpseoHandleKeyEvents(ev);\n\t\t});\n\n\t\tjQuery(".button-primary").click(function (ev) {\n\t\t\twpseoHandleButtonEvents(ev);\n\t\t});\n\t}\n\n\tif (wpseoCurrentPage === "edit-tags.php") {\n\t\tjQuery(document).on("ajaxComplete", function (e, xhr, settings) {\n\t\t\tif (settings.data.indexOf("action=delete-tag") > -1) {\n\t\t\t\twpseoShowNotification();\n\t\t\t}\n\t\t});\n\t}\n});//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///128\n')},14:function(module,exports){eval("module.exports = window.wp.apiFetch;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMTQuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vZXh0ZXJuYWwgXCJ3aW5kb3cud3AuYXBpRmV0Y2hcIj9iYzBmIl0sInNvdXJjZXNDb250ZW50IjpbIm1vZHVsZS5leHBvcnRzID0gd2luZG93LndwLmFwaUZldGNoOyJdLCJtYXBwaW5ncyI6IkFBQUEiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///14\n")},18:function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n\tvalue: true\n});\nexports.ALLOW_EMPTY_TARGET = undefined;\nexports.wpseoDeleteRedirect = wpseoDeleteRedirect;\nexports.wpseoRemoveNotification = wpseoRemoveNotification;\nexports.wpseoUndoRedirect = wpseoUndoRedirect;\nexports.wpseoCreateRedirect = wpseoCreateRedirect;\n\nvar _apiFetch = __webpack_require__(14);\n\nvar _apiFetch2 = _interopRequireDefault(_apiFetch);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\nvar ALLOW_EMPTY_TARGET = exports.ALLOW_EMPTY_TARGET = [410, 451];\n\n/**\n * Deletes a redirect.\n *\n * @param {string} origin The redirect\'s origin.\n * @param {string} target The redirect\'s target.\n * @param {string} type   The type of redirect.\n * @param {string} format The format of redirect.\n *\n * @returns {void}\n */\n/* global window, wpApiSettings, wpseoPremiumStrings, ajaxurl */\nfunction wpseoDeleteRedirect(origin, target, type) {\n\tvar format = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : "plain";\n\n\treturn (0, _apiFetch2.default)({\n\t\tmethod: "POST",\n\t\turl: wpApiSettings.root + "yoast/v1/redirects/delete",\n\t\theaders: {\n\t\t\t"X-WP-Nonce": wpApiSettings.nonce\n\t\t},\n\t\tdata: {\n\t\t\torigin: origin,\n\t\t\ttarget: target,\n\t\t\ttype: type,\n\t\t\tformat: format\n\t\t}\n\t});\n}\n\n/**\n * Removes a notification.\n *\n * @param {object} source The DOMElement containing the alerts.\n *\n * @returns {void}\n */\nfunction wpseoRemoveNotification(source) {\n\tjQuery(source).closest(".yoast-notification").fadeOut("slow");\n}\n\n/**\n * Undoes a redirect.\n *\n * @param {string} origin The redirect\'s origin.\n * @param {string} target The redirect\'s target.\n * @param {string} type The type of redirect.\n * @param {string} nonce The nonce being used to validate the current AJAX request.\n * @param {object} source The DOMElement containing the alerts.\n *\n * @returns {void}\n */\nfunction wpseoUndoRedirect(origin, target, type, nonce, source) {\n\twpseoDeleteRedirect(origin, target, type).then(function (response) {\n\t\tif (response.success === true) {\n\t\t\twpseoRemoveNotification(source);\n\t\t}\n\t});\n}\n\n/**\n * Creates a redirect\n *\n * @param {string} origin The origin.\n * @param {string} type   The redirect type, regex or plain.\n * @param {string} nonce  The nonce.\n * @param {object} source The source of the redirect.\n *\n * @returns {void}\n */\nfunction wpseoCreateRedirect(origin, type, nonce, source) {\n\tvar target = "";\n\n\tif (parseInt(type, 10) !== 410) {\n\t\t/* eslint-disable no-alert */\n\t\ttarget = window.prompt(wpseoPremiumStrings.enter_new_url.replace("%s", origin));\n\t\t/* eslint-enable no-alert */\n\n\t\tif (target === "") {\n\t\t\t/* eslint-disable no-alert */\n\t\t\twindow.alert(wpseoPremiumStrings.error_new_url);\n\t\t\t/* eslint-enable no-alert */\n\t\t\treturn;\n\t\t}\n\t}\n\n\tjQuery.post(ajaxurl, {\n\t\taction: "wpseo_add_redirect_plain",\n\t\t/* eslint-disable-next-line camelcase */\n\t\tajax_nonce: nonce,\n\t\tredirect: {\n\t\t\torigin: origin,\n\t\t\ttarget: target,\n\t\t\ttype: type\n\t\t}\n\t}, function (response) {\n\t\tvar notice = jQuery(source).closest(".yoast-notification");\n\t\t// Remove the classes first.\n\t\tjQuery(notice).removeClass("updated").removeClass("error");\n\n\t\t// Remove possibly added redirect errors.\n\t\tjQuery(notice).find(".redirect_error").remove();\n\n\t\tif (response.error) {\n\t\t\t// Add paragraph on top of the notice with actions and set class to error.\n\t\t\tjQuery(notice).addClass("error").prepend("<p class=\\"redirect_error\\">" + response.error.message + "</p>");\n\n\t\t\treturn;\n\t\t}\n\n\t\t// Parse the success message.\n\t\tvar successMessage = "";\n\t\tif (parseInt(type, 10) === 410) {\n\t\t\tsuccessMessage = wpseoPremiumStrings.redirect_saved_no_target;\n\t\t} else {\n\t\t\tsuccessMessage = wpseoPremiumStrings.redirect_saved.replace("%2$s", "<code>" + response.target + "</code>");\n\t\t}\n\n\t\tsuccessMessage = successMessage.replace("%1$s", "<code>" + response.origin + "</code>");\n\n\t\t// Set class to updated and replace html with the success message.\n\t\tjQuery(notice).addClass("updated").html("<p>" + successMessage + "</p>");\n\t}, "json");\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMTguanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vYXNzZXRzL2pzL3NyYy9yZWRpcmVjdHMvZnVuY3Rpb25zLmpzP2QxNmQiXSwic291cmNlc0NvbnRlbnQiOlsiLyogZ2xvYmFsIHdpbmRvdywgd3BBcGlTZXR0aW5ncywgd3BzZW9QcmVtaXVtU3RyaW5ncywgYWpheHVybCAqL1xuaW1wb3J0IGFwaUZldGNoIGZyb20gXCJAd29yZHByZXNzL2FwaS1mZXRjaFwiO1xuXG5leHBvcnQgY29uc3QgQUxMT1dfRU1QVFlfVEFSR0VUID0gW1xuXHQ0MTAsIDQ1MSxcbl07XG5cbi8qKlxuICogRGVsZXRlcyBhIHJlZGlyZWN0LlxuICpcbiAqIEBwYXJhbSB7c3RyaW5nfSBvcmlnaW4gVGhlIHJlZGlyZWN0J3Mgb3JpZ2luLlxuICogQHBhcmFtIHtzdHJpbmd9IHRhcmdldCBUaGUgcmVkaXJlY3QncyB0YXJnZXQuXG4gKiBAcGFyYW0ge3N0cmluZ30gdHlwZSAgIFRoZSB0eXBlIG9mIHJlZGlyZWN0LlxuICogQHBhcmFtIHtzdHJpbmd9IGZvcm1hdCBUaGUgZm9ybWF0IG9mIHJlZGlyZWN0LlxuICpcbiAqIEByZXR1cm5zIHt2b2lkfVxuICovXG5leHBvcnQgZnVuY3Rpb24gd3BzZW9EZWxldGVSZWRpcmVjdCggb3JpZ2luLCB0YXJnZXQsIHR5cGUsIGZvcm1hdCA9IFwicGxhaW5cIiApIHtcblx0cmV0dXJuIGFwaUZldGNoKFxuXHRcdHtcblx0XHRcdG1ldGhvZDogXCJQT1NUXCIsXG5cdFx0XHR1cmw6IHdwQXBpU2V0dGluZ3Mucm9vdCArIFwieW9hc3QvdjEvcmVkaXJlY3RzL2RlbGV0ZVwiLFxuXHRcdFx0aGVhZGVyczoge1xuXHRcdFx0XHRcIlgtV1AtTm9uY2VcIjogd3BBcGlTZXR0aW5ncy5ub25jZSxcblx0XHRcdH0sXG5cdFx0XHRkYXRhOiB7XG5cdFx0XHRcdG9yaWdpbixcblx0XHRcdFx0dGFyZ2V0LFxuXHRcdFx0XHR0eXBlLFxuXHRcdFx0XHRmb3JtYXQsXG5cdFx0XHR9LFxuXHRcdH1cblx0KTtcbn1cblxuLyoqXG4gKiBSZW1vdmVzIGEgbm90aWZpY2F0aW9uLlxuICpcbiAqIEBwYXJhbSB7b2JqZWN0fSBzb3VyY2UgVGhlIERPTUVsZW1lbnQgY29udGFpbmluZyB0aGUgYWxlcnRzLlxuICpcbiAqIEByZXR1cm5zIHt2b2lkfVxuICovXG5leHBvcnQgZnVuY3Rpb24gd3BzZW9SZW1vdmVOb3RpZmljYXRpb24oIHNvdXJjZSApIHtcblx0alF1ZXJ5KCBzb3VyY2UgKS5jbG9zZXN0KCBcIi55b2FzdC1ub3RpZmljYXRpb25cIiApLmZhZGVPdXQoIFwic2xvd1wiICk7XG59XG5cbi8qKlxuICogVW5kb2VzIGEgcmVkaXJlY3QuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IG9yaWdpbiBUaGUgcmVkaXJlY3QncyBvcmlnaW4uXG4gKiBAcGFyYW0ge3N0cmluZ30gdGFyZ2V0IFRoZSByZWRpcmVjdCdzIHRhcmdldC5cbiAqIEBwYXJhbSB7c3RyaW5nfSB0eXBlIFRoZSB0eXBlIG9mIHJlZGlyZWN0LlxuICogQHBhcmFtIHtzdHJpbmd9IG5vbmNlIFRoZSBub25jZSBiZWluZyB1c2VkIHRvIHZhbGlkYXRlIHRoZSBjdXJyZW50IEFKQVggcmVxdWVzdC5cbiAqIEBwYXJhbSB7b2JqZWN0fSBzb3VyY2UgVGhlIERPTUVsZW1lbnQgY29udGFpbmluZyB0aGUgYWxlcnRzLlxuICpcbiAqIEByZXR1cm5zIHt2b2lkfVxuICovXG5leHBvcnQgZnVuY3Rpb24gd3BzZW9VbmRvUmVkaXJlY3QoIG9yaWdpbiwgdGFyZ2V0LCB0eXBlLCBub25jZSwgc291cmNlICkge1xuXHR3cHNlb0RlbGV0ZVJlZGlyZWN0KCBvcmlnaW4sIHRhcmdldCwgdHlwZSApXG5cdFx0LnRoZW4oIHJlc3BvbnNlID0+IHtcblx0XHRcdGlmICggcmVzcG9uc2Uuc3VjY2VzcyA9PT0gdHJ1ZSApIHtcblx0XHRcdFx0d3BzZW9SZW1vdmVOb3RpZmljYXRpb24oIHNvdXJjZSApO1xuXHRcdFx0fVxuXHRcdH0gKTtcbn1cblxuLyoqXG4gKiBDcmVhdGVzIGEgcmVkaXJlY3RcbiAqXG4gKiBAcGFyYW0ge3N0cmluZ30gb3JpZ2luIFRoZSBvcmlnaW4uXG4gKiBAcGFyYW0ge3N0cmluZ30gdHlwZSAgIFRoZSByZWRpcmVjdCB0eXBlLCByZWdleCBvciBwbGFpbi5cbiAqIEBwYXJhbSB7c3RyaW5nfSBub25jZSAgVGhlIG5vbmNlLlxuICogQHBhcmFtIHtvYmplY3R9IHNvdXJjZSBUaGUgc291cmNlIG9mIHRoZSByZWRpcmVjdC5cbiAqXG4gKiBAcmV0dXJucyB7dm9pZH1cbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIHdwc2VvQ3JlYXRlUmVkaXJlY3QoIG9yaWdpbiwgdHlwZSwgbm9uY2UsIHNvdXJjZSApIHtcblx0dmFyIHRhcmdldCA9IFwiXCI7XG5cblx0aWYgKCBwYXJzZUludCggdHlwZSwgMTAgKSAhPT0gNDEwICkge1xuXHRcdC8qIGVzbGludC1kaXNhYmxlIG5vLWFsZXJ0ICovXG5cdFx0dGFyZ2V0ID0gd2luZG93LnByb21wdCggd3BzZW9QcmVtaXVtU3RyaW5ncy5lbnRlcl9uZXdfdXJsLnJlcGxhY2UoIFwiJXNcIiwgb3JpZ2luICkgKTtcblx0XHQvKiBlc2xpbnQtZW5hYmxlIG5vLWFsZXJ0ICovXG5cblx0XHRpZiAoIHRhcmdldCA9PT0gXCJcIiApIHtcblx0XHRcdC8qIGVzbGludC1kaXNhYmxlIG5vLWFsZXJ0ICovXG5cdFx0XHR3aW5kb3cuYWxlcnQoIHdwc2VvUHJlbWl1bVN0cmluZ3MuZXJyb3JfbmV3X3VybCApO1xuXHRcdFx0LyogZXNsaW50LWVuYWJsZSBuby1hbGVydCAqL1xuXHRcdFx0cmV0dXJuO1xuXHRcdH1cblx0fVxuXG5cdGpRdWVyeS5wb3N0KFxuXHRcdGFqYXh1cmwsXG5cdFx0e1xuXHRcdFx0YWN0aW9uOiBcIndwc2VvX2FkZF9yZWRpcmVjdF9wbGFpblwiLFxuXHRcdFx0LyogZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIGNhbWVsY2FzZSAqL1xuXHRcdFx0YWpheF9ub25jZTogbm9uY2UsXG5cdFx0XHRyZWRpcmVjdDoge1xuXHRcdFx0XHRvcmlnaW46IG9yaWdpbixcblx0XHRcdFx0dGFyZ2V0OiB0YXJnZXQsXG5cdFx0XHRcdHR5cGU6IHR5cGUsXG5cdFx0XHR9LFxuXHRcdH0sXG5cdFx0ZnVuY3Rpb24oIHJlc3BvbnNlICkge1xuXHRcdFx0dmFyIG5vdGljZSA9IGpRdWVyeSggc291cmNlICkuY2xvc2VzdCggXCIueW9hc3Qtbm90aWZpY2F0aW9uXCIgKTtcblx0XHRcdC8vIFJlbW92ZSB0aGUgY2xhc3NlcyBmaXJzdC5cblx0XHRcdGpRdWVyeSggbm90aWNlIClcblx0XHRcdFx0LnJlbW92ZUNsYXNzKCBcInVwZGF0ZWRcIiApXG5cdFx0XHRcdC5yZW1vdmVDbGFzcyggXCJlcnJvclwiICk7XG5cblx0XHRcdC8vIFJlbW92ZSBwb3NzaWJseSBhZGRlZCByZWRpcmVjdCBlcnJvcnMuXG5cdFx0XHRqUXVlcnkoIG5vdGljZSApLmZpbmQoIFwiLnJlZGlyZWN0X2Vycm9yXCIgKS5yZW1vdmUoKTtcblxuXHRcdFx0aWYgKCByZXNwb25zZS5lcnJvciApIHtcblx0XHRcdFx0Ly8gQWRkIHBhcmFncmFwaCBvbiB0b3Agb2YgdGhlIG5vdGljZSB3aXRoIGFjdGlvbnMgYW5kIHNldCBjbGFzcyB0byBlcnJvci5cblx0XHRcdFx0alF1ZXJ5KCBub3RpY2UgKVxuXHRcdFx0XHRcdC5hZGRDbGFzcyggXCJlcnJvclwiIClcblx0XHRcdFx0XHQucHJlcGVuZCggXCI8cCBjbGFzcz1cXFwicmVkaXJlY3RfZXJyb3JcXFwiPlwiICsgcmVzcG9uc2UuZXJyb3IubWVzc2FnZSArIFwiPC9wPlwiICk7XG5cblx0XHRcdFx0cmV0dXJuO1xuXHRcdFx0fVxuXG5cdFx0XHQvLyBQYXJzZSB0aGUgc3VjY2VzcyBtZXNzYWdlLlxuXHRcdFx0dmFyIHN1Y2Nlc3NNZXNzYWdlID0gXCJcIjtcblx0XHRcdGlmICggcGFyc2VJbnQoIHR5cGUsIDEwICkgPT09IDQxMCApIHtcblx0XHRcdFx0c3VjY2Vzc01lc3NhZ2UgPSB3cHNlb1ByZW1pdW1TdHJpbmdzLnJlZGlyZWN0X3NhdmVkX25vX3RhcmdldDtcblx0XHRcdH0gZWxzZSB7XG5cdFx0XHRcdHN1Y2Nlc3NNZXNzYWdlID0gd3BzZW9QcmVtaXVtU3RyaW5ncy5yZWRpcmVjdF9zYXZlZC5yZXBsYWNlKCBcIiUyJHNcIiwgXCI8Y29kZT5cIiArIHJlc3BvbnNlLnRhcmdldCArIFwiPC9jb2RlPlwiICk7XG5cdFx0XHR9XG5cblx0XHRcdHN1Y2Nlc3NNZXNzYWdlID0gc3VjY2Vzc01lc3NhZ2UucmVwbGFjZSggXCIlMSRzXCIsIFwiPGNvZGU+XCIgKyByZXNwb25zZS5vcmlnaW4gKyBcIjwvY29kZT5cIiApO1xuXG5cdFx0XHQvLyBTZXQgY2xhc3MgdG8gdXBkYXRlZCBhbmQgcmVwbGFjZSBodG1sIHdpdGggdGhlIHN1Y2Nlc3MgbWVzc2FnZS5cblx0XHRcdGpRdWVyeSggbm90aWNlIClcblx0XHRcdFx0LmFkZENsYXNzKCBcInVwZGF0ZWRcIiApXG5cdFx0XHRcdC5odG1sKCBcIjxwPlwiICsgc3VjY2Vzc01lc3NhZ2UgKyBcIjwvcD5cIiApO1xuXHRcdH0sXG5cdFx0XCJqc29uXCJcblx0KTtcbn1cbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBaUJBO0FBeUJBO0FBZUE7QUFtQkE7QUFDQTtBQTVFQTtBQUNBOzs7OztBQUNBO0FBQ0E7QUFHQTs7Ozs7Ozs7OztBQVBBO0FBaUJBO0FBQUE7QUFDQTtBQUFBO0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFEQTtBQUdBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFKQTtBQU5BO0FBY0E7QUFDQTtBQUNBOzs7Ozs7O0FBT0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7Ozs7Ozs7Ozs7QUFXQTtBQUNBO0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Ozs7Ozs7Ozs7QUFVQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBR0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFIQTtBQUpBO0FBV0E7QUFDQTtBQUNBO0FBQ0E7QUFHQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUdBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUdBO0FBR0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///18\n')}},[[128,0]]]);