(window.yoastPremiumWebpackJsonp=window.yoastPremiumWebpackJsonp||[]).push([[1],{115:function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n\tvalue: true\n});\nexports.retrieveMorphologyData = undefined;\n\n/**\n * Retrieves the morphology data.\n *\n * @param {Object} settings The indexation settings.\n *\n * @returns {Promise} The morphology data promise.\n */\nvar retrieveMorphologyData = exports.retrieveMorphologyData = function () {\n\tvar _ref = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(settings) {\n\t\tvar morphologyData, url;\n\t\treturn regeneratorRuntime.wrap(function _callee$(_context) {\n\t\t\twhile (1) {\n\t\t\t\tswitch (_context.prev = _context.next) {\n\t\t\t\t\tcase 0:\n\t\t\t\t\t\tmorphologyData = getMorphologyData();\n\n\t\t\t\t\t\t// Load morphology data only once and if it\'s supported.\n\n\t\t\t\t\t\tif (!(morphologyData || !settings.morphologySupported)) {\n\t\t\t\t\t\t\t_context.next = 3;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn _context.abrupt("return", Promise.resolve());\n\n\t\t\t\t\tcase 3:\n\t\t\t\t\t\turl = (0, _determineMorphologyRequestUrl.determineMorphologyRequestUrl)(settings.language || "en");\n\n\t\t\t\t\t\tif (!(url === false)) {\n\t\t\t\t\t\t\t_context.next = 6;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn _context.abrupt("return", Promise.resolve());\n\n\t\t\t\t\tcase 6:\n\t\t\t\t\t\t_context.next = 8;\n\t\t\t\t\t\treturn (0, _ajaxHelper.doAjaxRequest)("GET", url, null, {\n\t\t\t\t\t\t\t// Disable reason: this is how it is done in PHP (see MyYoast proxy).\n\t\t\t\t\t\t\tplugin_version: _package2.default.yoast.pluginVersion, // eslint-disable-line camelcase\n\t\t\t\t\t\t\tsite: settings.restApi.root.replace(/wp-json\\/$/, "")\n\t\t\t\t\t\t});\n\n\t\t\t\t\tcase 8:\n\t\t\t\t\t\tmorphologyData = _context.sent;\n\n\n\t\t\t\t\t\tsetMorphologyData(morphologyData);\n\t\t\t\t\t\treturn _context.abrupt("return", Promise.resolve(morphologyData));\n\n\t\t\t\t\tcase 11:\n\t\t\t\t\tcase "end":\n\t\t\t\t\t\treturn _context.stop();\n\t\t\t\t}\n\t\t\t}\n\t\t}, _callee, this);\n\t}));\n\n\treturn function retrieveMorphologyData(_x) {\n\t\treturn _ref.apply(this, arguments);\n\t};\n}();\n\nexports.setMorphologyData = setMorphologyData;\nexports.getMorphologyData = getMorphologyData;\nexports.extractProminentWords = extractProminentWords;\nexports.generateProminentWords = generateProminentWords;\n\nvar _yoastseo = __webpack_require__(13);\n\nvar _researcherFactory = __webpack_require__(116);\n\nvar _researcherFactory2 = _interopRequireDefault(_researcherFactory);\n\nvar _package = __webpack_require__(33);\n\nvar _package2 = _interopRequireDefault(_package);\n\nvar _compressWordsForLinking = __webpack_require__(34);\n\nvar _determineMorphologyRequestUrl = __webpack_require__(35);\n\nvar _ajaxHelper = __webpack_require__(117);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\nfunction _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }\n\nvar _morphologyData = false;\n\n/**\n * Sets the morphology data.\n *\n * @param {object} morphologyData The morphology data.\n *\n * @returns {void}\n */\nfunction setMorphologyData(morphologyData) {\n\t_morphologyData = morphologyData;\n}\n\n/**\n * Gets the morphology data.\n *\n * @returns {object} The morphology data.\n */\nfunction getMorphologyData() {\n\treturn _morphologyData;\n}\n\n/**\n * Extracts the prominent words from the given paper.\n *\n * @param {Paper}  paper             The paper.\n * @param {number} perIndexableLimit Maximum number of prominent words to extract.\n *\n * @returns {Object} The prominent words.\n */\nfunction extractProminentWords(paper, perIndexableLimit) {\n\tvar researcher = _researcherFactory2.default.create(paper);\n\n\tvar morphologyData = getMorphologyData();\n\tif (morphologyData) {\n\t\tresearcher.addResearchData("morphology", morphologyData);\n\t}\n\n\tvar research = researcher.getResearch("prominentWordsForInternalLinking");\n\treturn (0, _compressWordsForLinking.compressWordsForLinking)(research.prominentWords.slice(0, perIndexableLimit));\n}\n\n/**\n * Generates prominent words from the given indexable data.\n *\n * @param {Object} indexableData The indexable data.\n * @param {Object} settings      The indexation settings.\n *\n * @returns {Promise[]} The prominent word generation promises.\n */\nfunction generateProminentWords(indexableData, settings) {\n\tvar data = [];\n\n\tindexableData.forEach(function (indexable) {\n\t\t// Generate the prominent words for an indexable.\n\t\tvar paper = new _yoastseo.Paper(indexable.content, {\n\t\t\tkeyword: indexable.meta.primary_focus_keyword || "",\n\t\t\tsynonyms: indexable.meta.keyphrase_synonyms || "",\n\t\t\ttitle: indexable.meta.title || "",\n\t\t\tdescription: indexable.meta.description || "",\n\t\t\tlocale: settings.locale || "en_US"\n\t\t});\n\n\t\tvar prominentWords = extractProminentWords(paper);\n\n\t\t// Save the prominent words for the request.\n\t\tdata.push({\n\t\t\t// eslint-disable-next-line camelcase\n\t\t\tobject_id: indexable.object_id,\n\t\t\t// eslint-disable-next-line camelcase\n\t\t\tobject_type: indexable.object_type,\n\t\t\t// eslint-disable-next-line camelcase\n\t\t\tprominent_words: prominentWords\n\t\t});\n\t});\n\n\treturn (0, _ajaxHelper.doAjaxRequest)("POST", "" + settings.restApi.root + settings.prominentWords.endpoint, settings.restApi.nonce, { data: data });\n}\n\njQuery(function () {\n\twindow.yoast = window.yoast || {};\n\twindow.yoast.indexing = window.yoast.indexing || {};\n\tif (typeof window.yoast.indexing.registerPreIndexingAction === "function") {\n\t\twindow.yoast.indexing.registerPreIndexingAction("get_content", retrieveMorphologyData);\n\t}\n\tif (typeof window.yoast.indexing.registerIndexingAction === "function") {\n\t\twindow.yoast.indexing.registerIndexingAction("get_content", generateProminentWords);\n\t}\n});//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///115\n')},116:function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n\tvalue: true\n});\n\nvar _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();\n\nvar _yoastseo = __webpack_require__(13);\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\n/**\n * Researcher factory.\n */\nvar ResearcherFactory = function () {\n\tfunction ResearcherFactory() {\n\t\t_classCallCheck(this, ResearcherFactory);\n\t}\n\n\t_createClass(ResearcherFactory, null, [{\n\t\tkey: "create",\n\n\t\t/**\n  * Creates a researcher for the given paper\n  *\n  * @param {object} paper The paper to be analyzed.\n  *\n  * @returns {object} The researcher for the paper.\n  */\n\t\tvalue: function create(paper) {\n\t\t\treturn new _yoastseo.Researcher(paper);\n\t\t}\n\t}]);\n\n\treturn ResearcherFactory;\n}();\n\nexports.default = ResearcherFactory;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMTE2LmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vL2Fzc2V0cy9qcy9zcmMvZmFjdG9yaWVzL3Jlc2VhcmNoZXItZmFjdG9yeS5qcz9iZjI3Il0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFJlc2VhcmNoZXIgfSBmcm9tIFwieW9hc3RzZW9cIjtcblxuLyoqXG4gKiBSZXNlYXJjaGVyIGZhY3RvcnkuXG4gKi9cbmNsYXNzIFJlc2VhcmNoZXJGYWN0b3J5IHtcblx0LyoqXG5cdCogQ3JlYXRlcyBhIHJlc2VhcmNoZXIgZm9yIHRoZSBnaXZlbiBwYXBlclxuXHQqXG5cdCogQHBhcmFtIHtvYmplY3R9IHBhcGVyIFRoZSBwYXBlciB0byBiZSBhbmFseXplZC5cblx0KlxuXHQqIEByZXR1cm5zIHtvYmplY3R9IFRoZSByZXNlYXJjaGVyIGZvciB0aGUgcGFwZXIuXG5cdCovXG5cdHN0YXRpYyBjcmVhdGUoIHBhcGVyICkge1xuXHRcdHJldHVybiBuZXcgUmVzZWFyY2hlciggcGFwZXIgKTtcblx0fVxufVxuXG5leHBvcnQgZGVmYXVsdCBSZXNlYXJjaGVyRmFjdG9yeTtcbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7QUFBQTtBQUNBOzs7QUFDQTs7O0FBR0E7Ozs7Ozs7O0FBQ0E7Ozs7Ozs7QUFPQTtBQUNBO0FBQ0E7Ozs7OztBQUdBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///116\n')},117:function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n\tvalue: true\n});\nexports.doAjaxRequest = doAjaxRequest;\n/**\n * Perform a (promisified) ajax request.\n *\n * @param {string} method  HTTP Method ( i.e. "POST" or "GET" ).\n * @param {string} url     Ajax url.\n * @param {string} nonce   WordPress nonce, can be null.\n * @param {any}    payload Request payload.\n *\n * @returns {Promise} A promise.\n */\nfunction doAjaxRequest(method, url, nonce, payload) {\n\treturn new Promise(function (resolve, reject) {\n\t\tjQuery.ajax({\n\t\t\ttype: method,\n\t\t\turl: url,\n\t\t\tbeforeSend: nonce ? function (xhr) {\n\t\t\t\txhr.setRequestHeader("X-WP-Nonce", nonce);\n\t\t\t} : null,\n\t\t\tdata: payload,\n\t\t\tdataType: "json",\n\t\t\tsuccess: resolve,\n\t\t\terror: reject\n\t\t});\n\t});\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMTE3LmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4uL2pzL3NyYy9oZWxwZXJzL2FqYXhIZWxwZXIuanM/OWI0YSJdLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIFBlcmZvcm0gYSAocHJvbWlzaWZpZWQpIGFqYXggcmVxdWVzdC5cbiAqXG4gKiBAcGFyYW0ge3N0cmluZ30gbWV0aG9kICBIVFRQIE1ldGhvZCAoIGkuZS4gXCJQT1NUXCIgb3IgXCJHRVRcIiApLlxuICogQHBhcmFtIHtzdHJpbmd9IHVybCAgICAgQWpheCB1cmwuXG4gKiBAcGFyYW0ge3N0cmluZ30gbm9uY2UgICBXb3JkUHJlc3Mgbm9uY2UsIGNhbiBiZSBudWxsLlxuICogQHBhcmFtIHthbnl9ICAgIHBheWxvYWQgUmVxdWVzdCBwYXlsb2FkLlxuICpcbiAqIEByZXR1cm5zIHtQcm9taXNlfSBBIHByb21pc2UuXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBkb0FqYXhSZXF1ZXN0KCBtZXRob2QsIHVybCwgbm9uY2UsIHBheWxvYWQgKSB7XG5cdHJldHVybiBuZXcgUHJvbWlzZSggKCByZXNvbHZlLCByZWplY3QgKSA9PiB7XG5cdFx0alF1ZXJ5LmFqYXgoIHtcblx0XHRcdHR5cGU6IG1ldGhvZCxcblx0XHRcdHVybCxcblx0XHRcdGJlZm9yZVNlbmQ6IG5vbmNlID8gKCB4aHIgKSA9PiB7XG5cdFx0XHRcdHhoci5zZXRSZXF1ZXN0SGVhZGVyKCBcIlgtV1AtTm9uY2VcIiwgbm9uY2UgKTtcblx0XHRcdH0gOiBudWxsLFxuXHRcdFx0ZGF0YTogcGF5bG9hZCxcblx0XHRcdGRhdGFUeXBlOiBcImpzb25cIixcblx0XHRcdHN1Y2Nlc3M6IHJlc29sdmUsXG5cdFx0XHRlcnJvcjogcmVqZWN0LFxuXHRcdH0gKTtcblx0fSApO1xufVxuIl0sIm1hcHBpbmdzIjoiOzs7OztBQVVBO0FBVkE7Ozs7Ozs7Ozs7QUFVQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFUQTtBQVdBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///117\n')},13:function(module,exports){eval("module.exports = window.yoast.analysis;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMTMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vZXh0ZXJuYWwgXCJ3aW5kb3cueW9hc3QuYW5hbHlzaXNcIj9jNDdjIl0sInNvdXJjZXNDb250ZW50IjpbIm1vZHVsZS5leHBvcnRzID0gd2luZG93LnlvYXN0LmFuYWx5c2lzOyJdLCJtYXBwaW5ncyI6IkFBQUEiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///13\n")},33:function(module){eval('module.exports = {"name":"wordpress-seo-premium","license":"GPL-2.0+","description":"Development files for the Yoast SEO Premium plugin","plugin":{"glotpress":"http://translate.yoast.com","slug":"wordpress-seo-premium","textdomain":"wordpress-seo-premium"},"pot":{"reportmsgidbugsto":"https://github.com/yoast/wordpress-seo-premium/issues","languageteam":"Yoast Translate <translations@yoast.com>","lasttranslator":"Yoast Translate Team <translations@yoast.com>"},"repository":{"type":"git","url":"https://github.com/Yoast/wordpress-seo-premium"},"scripts":{"build":"NODE_ENV=production webpack --config ./config/webpack/webpack.config.dev.js --progress --display-error-details","start":"webpack-dev-server --config ./config/webpack/webpack.config.dev.js --progress --env.environment=development --port=8081","webpack-analyze-bundle":"cross-env BUNDLE_ANALYZER=1 NODE_ENV=production webpack --config ./config/webpack/webpack.config.prod.js --progress","i18n-wordpress-seo-premium":"NODE_ENV=production babel assets/js/src --plugins=@wordpress/babel-plugin-makepot > /dev/null","link-monorepo":"node scripts/link_monorepo_to_premium.js","unlink-monorepo":"node scripts/unlink_monorepo.js"},"devDependencies":{"@wordpress/babel-plugin-makepot":"^2.0.1","@wordpress/block-library":"^2.22.6","@yoast/grunt-plugin-tasks":"^1.7.2","babel-cli":"^6.26.0","babel-core":"^6.13.2","babel-preset-es2015":"^6.13.2","babel-preset-react":"^6.11.1","case-sensitive-paths-webpack-plugin":"^2.1.2","cross-env":"^7.0.2","css-loader":"^3.4.2","envify":"^3.4.1","eslint":"^6.6.0","grunt-po2json":"^0.3.0","grunt-webpack":"^3.1.3","jest":"^18.1.0","webpack":"^4.20.2","webpack-bundle-analyzer":"^4.2.0","webpack-cli":"^3.1.2","webpack-dev-server":"^3.1.14"},"dependencies":{"@yoast/social-metadata-previews":"^1.9.0","a11y-speak":"github:yoast/a11y-speak","babel-loader":"^7.1.5","babel-plugin-dynamic-import-webpack":"^1.1.0","babel-polyfill":"^6.16.0","concat-map":"^0.0.1","interpolate-components":"^1.1.0","lodash":"^4.7.0","sassdash":"^0.9.0","yoast-social-previews":"git+ssh://git@github.com/Yoast/yoast-social-previews#1.4.3"},"browserslist":["extends @yoast/browserslist-config"],"yoast":{"pluginVersion":"15.5"}};//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMzMuanMiLCJzb3VyY2VzIjpbXSwibWFwcGluZ3MiOiIiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///33\n')},34:function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n  value: true\n});\nexports.compressWordsForLinking = compressWordsForLinking;\n/**\n * Changes the given words from an array to an object.\n * This object maps the stems of the words to their occurrences.\n *\n * @param {ProminentWord[]} wordsForLinking The prominent words to compress.\n *\n * @returns {Object} Prominent words object with the stems as keys and the number of occurrences as values.\n */\nfunction compressWordsForLinking(wordsForLinking) {\n  var compressedWords = {};\n\n  wordsForLinking.forEach(function (word) {\n    compressedWords[word.getStem()] = word.getOccurrences();\n  });\n\n  return compressedWords;\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMzQuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vYXNzZXRzL2pzL3NyYy9oZWxwZXJzL2NvbXByZXNzV29yZHNGb3JMaW5raW5nLmpzPzYwM2EiXSwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBDaGFuZ2VzIHRoZSBnaXZlbiB3b3JkcyBmcm9tIGFuIGFycmF5IHRvIGFuIG9iamVjdC5cbiAqIFRoaXMgb2JqZWN0IG1hcHMgdGhlIHN0ZW1zIG9mIHRoZSB3b3JkcyB0byB0aGVpciBvY2N1cnJlbmNlcy5cbiAqXG4gKiBAcGFyYW0ge1Byb21pbmVudFdvcmRbXX0gd29yZHNGb3JMaW5raW5nIFRoZSBwcm9taW5lbnQgd29yZHMgdG8gY29tcHJlc3MuXG4gKlxuICogQHJldHVybnMge09iamVjdH0gUHJvbWluZW50IHdvcmRzIG9iamVjdCB3aXRoIHRoZSBzdGVtcyBhcyBrZXlzIGFuZCB0aGUgbnVtYmVyIG9mIG9jY3VycmVuY2VzIGFzIHZhbHVlcy5cbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIGNvbXByZXNzV29yZHNGb3JMaW5raW5nKCB3b3Jkc0ZvckxpbmtpbmcgKSB7XG5cdGNvbnN0IGNvbXByZXNzZWRXb3JkcyA9IHt9O1xuXG5cdHdvcmRzRm9yTGlua2luZy5mb3JFYWNoKCBmdW5jdGlvbiggd29yZCApIHtcblx0XHRjb21wcmVzc2VkV29yZHNbIHdvcmQuZ2V0U3RlbSgpIF0gPSB3b3JkLmdldE9jY3VycmVuY2VzKCk7XG5cdH0gKTtcblxuXHRyZXR1cm4gY29tcHJlc3NlZFdvcmRzO1xufVxuIl0sIm1hcHBpbmdzIjoiOzs7OztBQVFBO0FBUkE7Ozs7Ozs7O0FBUUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///34\n')},35:function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n\tvalue: true\n});\nexports.determineMorphologyRequestUrl = determineMorphologyRequestUrl;\n/**\n * Returns the correct URL for the morphology data request based on the language.\n *\n * @param {string} language The language for which to make a morphology data request.\n *\n * @returns {string|boolean} The URL for the morphology data request or false if the language doesn\'t have morphology support.\n */\nfunction determineMorphologyRequestUrl(language) {\n\tvar versions = {\n\t\ten: "v4",\n\t\tde: "v9",\n\t\tes: "v9",\n\t\tfr: "v9",\n\t\tit: "v9",\n\t\tnl: "v9",\n\t\tru: "v9",\n\t\tid: "v9",\n\t\tpt: "v9",\n\t\tpl: "v9",\n\t\tar: "v9",\n\t\tsv: "v1",\n\t\the: "v1",\n\t\thu: "v1"\n\t};\n\n\tif (!Object.keys(versions).includes(language)) {\n\t\treturn false;\n\t}\n\n\tvar baseRequestUrl = "https://my.yoast.com/api/downloads/file/morphology";\n\n\treturn baseRequestUrl + "-" + language + "-" + versions[language];\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMzUuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vYXNzZXRzL2pzL3NyYy9oZWxwZXJzL2RldGVybWluZU1vcnBob2xvZ3lSZXF1ZXN0VXJsLmpzP2VhY2IiXSwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBSZXR1cm5zIHRoZSBjb3JyZWN0IFVSTCBmb3IgdGhlIG1vcnBob2xvZ3kgZGF0YSByZXF1ZXN0IGJhc2VkIG9uIHRoZSBsYW5ndWFnZS5cbiAqXG4gKiBAcGFyYW0ge3N0cmluZ30gbGFuZ3VhZ2UgVGhlIGxhbmd1YWdlIGZvciB3aGljaCB0byBtYWtlIGEgbW9ycGhvbG9neSBkYXRhIHJlcXVlc3QuXG4gKlxuICogQHJldHVybnMge3N0cmluZ3xib29sZWFufSBUaGUgVVJMIGZvciB0aGUgbW9ycGhvbG9neSBkYXRhIHJlcXVlc3Qgb3IgZmFsc2UgaWYgdGhlIGxhbmd1YWdlIGRvZXNuJ3QgaGF2ZSBtb3JwaG9sb2d5IHN1cHBvcnQuXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBkZXRlcm1pbmVNb3JwaG9sb2d5UmVxdWVzdFVybCggbGFuZ3VhZ2UgKSB7XG5cdGNvbnN0IHZlcnNpb25zID0ge1xuXHRcdGVuOiBcInY0XCIsXG5cdFx0ZGU6IFwidjlcIixcblx0XHRlczogXCJ2OVwiLFxuXHRcdGZyOiBcInY5XCIsXG5cdFx0aXQ6IFwidjlcIixcblx0XHRubDogXCJ2OVwiLFxuXHRcdHJ1OiBcInY5XCIsXG5cdFx0aWQ6IFwidjlcIixcblx0XHRwdDogXCJ2OVwiLFxuXHRcdHBsOiBcInY5XCIsXG5cdFx0YXI6IFwidjlcIixcblx0XHRzdjogXCJ2MVwiLFxuXHRcdGhlOiBcInYxXCIsXG5cdFx0aHU6IFwidjFcIixcblx0fTtcblxuXHRpZiAoICEgT2JqZWN0LmtleXMoIHZlcnNpb25zICkuaW5jbHVkZXMoIGxhbmd1YWdlICkgKSB7XG5cdFx0cmV0dXJuIGZhbHNlO1xuXHR9XG5cblx0Y29uc3QgYmFzZVJlcXVlc3RVcmwgPSBcImh0dHBzOi8vbXkueW9hc3QuY29tL2FwaS9kb3dubG9hZHMvZmlsZS9tb3JwaG9sb2d5XCI7XG5cblx0cmV0dXJuIGAkeyBiYXNlUmVxdWVzdFVybCB9LSR7IGxhbmd1YWdlIH0tJHsgdmVyc2lvbnNbIGxhbmd1YWdlIF0gfWA7XG59XG4iXSwibWFwcGluZ3MiOiI7Ozs7O0FBT0E7QUFQQTs7Ozs7OztBQU9BO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBZEE7QUFDQTtBQWdCQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///35\n')}},[[115,0]]]);