<?php
/**
 * The template for displaying 404 pages (not found).
 *
 * @package storefront
 */

get_header(); ?>

	<div id="primary" class="content-area">

		<main id="main" class="site-main" role="main">

			<div class="error-404 not-found">
                
                
        <div class="content_wrap">

            <?php get_template_part( 'template-parts/left', 'sidebar' ); ?>
            <div class="right_cont">
              <h1>Page Not Found</h1>
               <p><?php esc_html_e( 'Nothing was found at this location. Try searching, or check out the links below.', 'storefront' ); ?></p>
               	<?php
					echo '<section aria-label="' . esc_html__( 'Search', 'storefront' ) . '">';

					if ( storefront_is_woocommerce_activated() ) {
						the_widget( 'WC_Widget_Product_Search' );
					} else {
						get_search_form();
					}

					echo '</section>';
                ?>
                <div>
                    <a class="main_btn" href="<?php echo site_url(); ?>">Home</a>
                    <a class="main_btn" href="<?php echo site_url(); ?>/contact-extreme-parts/">Contact Us</a>
                </div>
            </div>
        </div>

				
			</div><!-- .error-404 -->

		</main><!-- #main -->
	</div><!-- #primary -->

<?php
get_footer();
