<?php
/**
 * The header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content">
 *
 * @package storefront
 */

?><!doctype html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=2.0">
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<?php wp_body_open(); ?>

<?php do_action( 'storefront_before_site' ); ?>

<div id="page" class="hfeed site">
	<?php do_action( 'storefront_before_header' ); ?>

	<header id="masthead" class="site-header" role="banner" style="<?php storefront_header_styles(); ?>">

		<?php
		/**
		 * Functions hooked into storefront_header action
		 *
		 * @hooked storefront_header_container                 - 0
		 * @hooked storefront_skip_links                       - 5
		 * @hooked storefront_social_icons                     - 10
		 * @hooked storefront_site_branding                    - 20
		 * @hooked storefront_secondary_navigation             - 30
		 * @hooked storefront_product_search                   - 40
		 * @hooked storefront_header_container_close           - 41
		 * @hooked storefront_primary_navigation_wrapper       - 42
		 * @hooked storefront_primary_navigation               - 50
		 * @hooked storefront_header_cart                      - 60
		 * @hooked storefront_primary_navigation_wrapper_close - 68
		 */
		//do_action( 'storefront_header' );
		?>
		<div class="mobile_menu">
        <div class="container">
        <div class="mobile_logo_wrap">
         <div class="mobile_logo"><?php storefront_site_branding(); ?></div>
		    <div class="hamburger">
                        <div class="hamburger-box">
                            <div class="hamburger-inner"></div>
                        </div>
            </div>
              </div>
              </div>
		</div>
		<div class="top_bar">
		    <div class="container">
            <div class="top_wrap">
		        <div class="left_info">
		                <h5>Proudly Canadian</h5>
		        </div>
		        <div class="right_info">
		            <div class="phn_num">
		                <div><a href="tel://1-877-504-0138"><i class="fas fa-phone-alt"></i> 1-877-504-0138</a></div>
		                <div><span>Local</span>: <a href="tel://905-605-1260">905-605-1260</a></div>
		            </div>
		        </div>
		        </div>
		    </div>
		</div>
		
		<div class="logo">
		    <div class="container">
		        <?php storefront_site_branding(); ?>
		        <h3>BODY PARTS • SPOILERS • KITS • PERFORMANCE</h3>
		    </div>
		</div>

	</header><!-- #masthead -->

	<?php
	/**
	 * Functions hooked in to storefront_before_content
	 *
	 * @hooked storefront_header_widget_region - 10
	 * @hooked woocommerce_breadcrumb - 10
	 */
	//do_action( 'storefront_before_content' );
	?>

	<div id="content" class="site-content" tabindex="-1">
		<div class="container">

		<?php
		do_action( 'storefront_content_top' );
