<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

get_header( 'shop' );

/**
 * Hook: woocommerce_before_main_content.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked woocommerce_breadcrumb - 20
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
do_action( 'woocommerce_before_main_content' );

?>


<div class="content_wrap">

    <?php get_template_part( 'template-parts/left', 'sidebar' ); ?>
    <div class="right_cont">

        <?php  	
   $term = get_queried_object()->term_id;
   $termid = get_term($term, 'product_cat' );
  $thumbnail_id = get_term_meta( $term , 'thumbnail_id', true );
   $image = wp_get_attachment_url( $thumbnail_id );
 ?>

        <?php if($termid->parent == 0)  { ?>

        <div class="main_cat_title">
            <div class="cat_bg">
                <?php if ( is_search() ) { ?>
                <h1 class="main_cat"><?php woocommerce_page_title(); ?></h1>
                <?php }  else { ?>
                <h1 class="main_cat">Shop <?php woocommerce_page_title(); ?> <span>Aftermarket Accessories</span></h1>
                <?php } ?>
            </div>
        </div>
        <?php if ( !is_search() ) { ?>
        <h2>Choose your model</h2>
        <?php } ?>
        <?php } 
           elseif ($termid->parent > 0) { ?>

        <div class="sub_cat_title">
            <div class="cat_bg">
                <h1 class="sub_cat"><?php woocommerce_page_title(); ?> <span>Aftermarket Accessories</span></h1>

            </div>
            <div class="cat_img">
                <?php if ( $image ) {
		    echo '<img src="' . $image . '" alt="' . $cat->name . '" />';
		} ?></div>
        </div>

        <?php     }
                
                ?>



        <?php
if ( woocommerce_product_loop() ) {

	/**
	 * Hook: woocommerce_before_shop_loop.
	 *
	 * @hooked woocommerce_output_all_notices - 10
	 * @hooked woocommerce_result_count - 20
	 * @hooked woocommerce_catalog_ordering - 30
	 */
	do_action( 'woocommerce_before_shop_loop' );

	woocommerce_product_loop_start();

	if ( wc_get_loop_prop( 'total' ) ) {
		while ( have_posts() ) {
			the_post();

			/**
			 * Hook: woocommerce_shop_loop.
			 */
			do_action( 'woocommerce_shop_loop' );

			wc_get_template_part( 'content', 'product' );
		}
	}

	woocommerce_product_loop_end();

	/**
	 * Hook: woocommerce_after_shop_loop.
	 *
	 * @hooked woocommerce_pagination - 10
	 */
	do_action( 'woocommerce_after_shop_loop' );
} else {
	/**
	 * Hook: woocommerce_no_products_found.
	 *
	 * @hooked wc_no_products_found - 10
	 */
	do_action( 'woocommerce_no_products_found' );
}

/**
 * Hook: woocommerce_after_main_content.
 *
 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
 */
do_action( 'woocommerce_after_main_content' );

/**
 * Hook: woocommerce_sidebar.
 *
 * @hooked woocommerce_get_sidebar - 10
 */
//do_action( 'woocommerce_sidebar' );?>

    </div>
</div>

<?php get_footer( 'shop' ); 